/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import java.util.List;
import org.brackit.xquery.BrackitQueryContext;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.array.DArray;
import org.brackit.xquery.expr.SequenceExpr;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.magicwerk.brownies.collections.GapList;

public final class ArrayExpr
implements Expr {
    private final Expr[] expr;
    private final boolean[] flatten;

    public ArrayExpr(Expr[] expr, boolean[] flatten) {
        this.expr = expr;
        this.flatten = flatten;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple t) {
        return this.evaluateToItem(ctx, t);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple t) {
        GapList vals = new GapList();
        for (int i = 0; i < this.expr.length; ++i) {
            Sequence res = this.expr[i].evaluate(ctx, t);
            if (res == null) continue;
            if (!(res instanceof SequenceExpr.EvalSequence) && !this.flatten[i] || res instanceof Item) {
                vals.add((Object)res);
                continue;
            }
            try (Iter it = res.iterate();){
                Item item;
                while ((item = it.next()) != null) {
                    vals.add((Object)item);
                }
                continue;
            }
        }
        return new DArray((List<? extends Sequence>)vals);
    }

    @Override
    public boolean isUpdating() {
        for (Expr e : this.expr) {
            if (!e.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        for (Expr e : this.expr) {
            if (e.isVacuous()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        boolean first = true;
        for (int i = 0; i < this.expr.length; ++i) {
            if (!first) {
                out.append(", ");
            }
            first = false;
            if (this.flatten[i]) {
                out.append("=");
            }
            out.append(this.expr[i].toString());
        }
        out.append("]");
        return out.toString();
    }

    public static void main(String[] args) {
        new XQuery("[ 1, '2', 3, (1 > 0) cast as xs:boolean, 1.2343 + 5, =(1,2,3)  ][[4]]").serialize((QueryContext)new BrackitQueryContext(), System.out);
    }
}

