/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.atomic.Una;
import org.brackit.xquery.expr.ConstructedNodeBuilder;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;

public class AttributeExpr
extends ConstructedNodeBuilder
implements Expr {
    protected final StaticContext sctx;
    protected final Expr nameExpr;
    protected final Expr[] valueExpr;
    protected final boolean appendOnly;
    protected final QNm name;

    public AttributeExpr(StaticContext sctx, Expr nameExpr, Expr[] valueExpr, boolean appendOnly) {
        this.sctx = sctx;
        this.nameExpr = nameExpr;
        this.valueExpr = valueExpr;
        this.appendOnly = appendOnly;
        this.name = (QNm)(nameExpr instanceof QNm ? nameExpr : null);
    }

    @Override
    public final Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        QNm name;
        QNm qNm = name = this.name != null ? this.name : this.buildAttributeName(this.sctx, this.nameExpr.evaluateToItem(ctx, tuple));
        if ("xmlns".equals(name.getPrefix())) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAME_OF_CONSTRUCTED_ATTRIBUTE, "Attribute name prefix must not be \"xmlns\"");
        }
        if (name.getPrefix() == null && "xmlns".equals(name.getLocalName())) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAME_OF_CONSTRUCTED_ATTRIBUTE, "Attribute name must not be \"xmlns\"");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(name.getNamespaceURI())) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAME_OF_CONSTRUCTED_ATTRIBUTE, "Attribute name namespace URI must not be \"http://www.w3.org/2000/xmlns/\"");
        }
        if ("xml".equals(name.getPrefix()) ? !"http://www.w3.org/XML/1998/namespace".equals(name.getNamespaceURI()) : "http://www.w3.org/XML/1998/namespace".equals(name.getNamespaceURI())) {
            throw new QueryException(ErrorCode.ERR_ILLEGAL_NAME_OF_CONSTRUCTED_ATTRIBUTE, "Namespace prefix \"xml\" must be bound to namespace URI other than \"http://www.w3.org/XML/1998/namespace\"");
        }
        Object stringValue = "";
        for (Expr e : this.valueExpr) {
            Sequence content = e.evaluate(ctx, tuple);
            stringValue = (String)stringValue + this.buildAttributeContent(content);
        }
        if (this.appendOnly) {
            ((Node)tuple.get(tuple.getSize() - 1)).setAttribute(name, new Una((String)stringValue));
            return null;
        }
        Object attribute = ctx.getNodeFactory().attribute(name, new Str((String)stringValue));
        return attribute;
    }

    @Override
    public boolean isUpdating() {
        if (this.nameExpr.isUpdating()) {
            return this.isUpdating();
        }
        for (Expr e : this.valueExpr) {
            if (!e.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return "attribute";
    }
}

