/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.translator.Reference;
import org.brackit.xquery.expr.Variable;
import org.brackit.xquery.sequence.TypedSequence;
import org.brackit.xquery.util.ExprUtil;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.type.SequenceType;

public class BoundVariable
extends Variable
implements Reference {
    private int pos = -1;

    public BoundVariable(QNm name, SequenceType type) {
        super(name, type);
    }

    public BoundVariable(QNm name, int pos) {
        super(name);
        this.pos = pos;
    }

    @Override
    public void setPos(int pos) {
        this.pos = pos;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence s;
        try {
            s = tuple.get(this.pos);
        }
        catch (QueryException e) {
            throw new QueryException(e, e.getCode(), "Could not resolve variable %s in tuple[%s] at position %s: %s", this.name, tuple.getSize(), this.pos, tuple);
        }
        if (this.type != null) {
            s = TypedSequence.toTypedSequence(this.type, s);
        }
        return s;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence s;
        try {
            s = tuple.get(this.pos);
        }
        catch (QueryException e) {
            throw new QueryException(e, e.getCode(), "Could not resolve variable %s in tuple at position %s: %s", this.name, tuple.getSize(), this.pos, tuple);
        }
        if (this.type != null) {
            return TypedSequence.toTypedItem(this.type, s);
        }
        return ExprUtil.asItem(s);
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

