/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.Unit;
import org.brackit.xquery.expr.Variable;
import org.brackit.xquery.operator.TupleImpl;
import org.brackit.xquery.sequence.TypedSequence;
import org.brackit.xquery.util.ExprUtil;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.type.SequenceType;

public class DeclVariable
extends Variable
implements Unit {
    private Expr expr;

    public DeclVariable(QNm name, SequenceType type) {
        super(name, type);
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence s;
        if (ctx.isBound(this.name)) {
            s = ctx.resolve(this.name);
        } else if (this.expr != null) {
            s = this.expr.evaluate(ctx, TupleImpl.EMPTY_TUPLE);
            ctx.bind(this.name, s);
        } else {
            throw new QueryException(ErrorCode.ERR_DYNAMIC_CONTEXT_VARIABLE_NOT_DEFINED, "Variable %s has not been bound", this.name);
        }
        if (this.type != null) {
            s = TypedSequence.toTypedSequence(this.type, s);
        }
        return s;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence res = ctx.resolve(this.name);
        if (res == null) {
            if (this.expr == null) {
                throw new QueryException(ErrorCode.ERR_DYNAMIC_CONTEXT_VARIABLE_NOT_DEFINED, "Variable %s has not been bound", this.name);
            }
            res = this.expr.evaluate(ctx, TupleImpl.EMPTY_TUPLE);
        }
        if (this.type != null) {
            return TypedSequence.toTypedItem(this.type, res);
        }
        return ExprUtil.asItem(res);
    }

    @Override
    public void setExpr(Expr expr) {
        this.expr = expr;
    }
}

