/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.compiler.Bits;
import org.brackit.xquery.compiler.Unit;
import org.brackit.xquery.expr.Variable;
import org.brackit.xquery.sequence.TypedSequence;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.type.AnyItemType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.ItemType;
import org.brackit.xquery.xdm.type.SequenceType;

public class DefaultCtxItem
extends Variable
implements Unit {
    private Expr expr;
    private ItemType type = AnyItemType.ANY;
    private boolean external = true;
    private Item item;

    public DefaultCtxItem() {
        super(Bits.FS_DOT);
    }

    @Override
    public void setExpr(Expr expr) {
        this.expr = expr;
    }

    public void setType(ItemType type) {
        this.type = type;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        if (this.item != null) {
            return this.item;
        }
        Item i = null;
        if (this.external) {
            i = ctx.getContextItem();
        }
        if (i == null && this.expr != null) {
            i = this.expr.evaluateToItem(ctx, tuple);
        }
        if (i == null) {
            throw new QueryException(ErrorCode.ERR_DYNAMIC_CONTEXT_VARIABLE_NOT_DEFINED, "Dynamic context variable %s is not assigned a value", this.name);
        }
        this.item = TypedSequence.toTypedItem(new SequenceType(this.type, Cardinality.One), i);
        return i;
    }
}

