/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import java.util.ArrayList;
import java.util.List;
import org.brackit.xquery.BrackitQueryContext;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.Bits;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.util.ExprUtil;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.json.Array;
import org.brackit.xquery.xdm.json.Record;

public class DerefExpr
implements Expr {
    final Expr record;
    final Expr[] fields;

    public DerefExpr(Expr record, Expr[] fields) {
        this.record = record;
        this.fields = fields;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence sequence = this.record.evaluate(ctx, tuple);
        for (int index = 0; index < this.fields.length && sequence != null; ++index) {
            Sequence resultSequence = this.processSequence(ctx, tuple, sequence, index);
            if (resultSequence == null) continue;
            return resultSequence;
        }
        return null;
    }

    private Sequence processSequence(QueryContext ctx, Tuple tuple, Sequence sequence, int index) {
        if (sequence instanceof Array) {
            return this.processArray(ctx, tuple, this.getSequenceValues(ctx, tuple, (Array)sequence, this.fields[index]));
        }
        if (sequence instanceof Record) {
            return this.processRecord(sequence, index, ctx, tuple);
        }
        if (sequence instanceof LazySequence) {
            return this.processLazySequence(ctx, tuple, sequence, index);
        }
        return null;
    }

    private Sequence processLazySequence(final QueryContext ctx, final Tuple tuple, final Sequence sequence, final int index) {
        return new LazySequence(){

            @Override
            public Iter iterate() {
                final Iter iter = sequence.iterate();
                return new BaseIter(){
                    Iter nestedIter;

                    @Override
                    public Item next() {
                        Item item = null;
                        if (this.nestedIter != null) {
                            item = this.nextItem(this.nestedIter);
                        }
                        if (item == null) {
                            item = this.nextItem(iter);
                        }
                        return item;
                    }

                    private Item nextItem(Iter iter2) {
                        Item item;
                        while ((item = iter2.next()) != null) {
                            if (iter2 == this.nestedIter) {
                                return item;
                            }
                            Sequence resultItem = DerefExpr.this.processSequence(ctx, tuple, item, index);
                            if (resultItem == null) continue;
                            if (resultItem instanceof LazySequence) {
                                this.nestedIter = resultItem.iterate();
                                resultItem = this.next();
                                if (resultItem == null) continue;
                            }
                            return resultItem.evaluateToItem(ctx, tuple);
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    private Sequence processArray(final QueryContext ctx, final Tuple tuple, final List<Sequence> values) {
        return new LazySequence(){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    int i;

                    @Override
                    public Item next() {
                        if (this.i < values.size()) {
                            return ((Sequence)values.get(this.i++)).evaluateToItem(ctx, tuple);
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    private Sequence processRecord(Sequence sequence, int index, QueryContext ctx, Tuple tuple) {
        Record record = (Record)sequence;
        Item field = this.fields[index].evaluateToItem(ctx, tuple);
        if (field == null) {
            return null;
        }
        return this.getSequenceByRecordField(record, field);
    }

    private List<Sequence> getSequenceValues(QueryContext ctx, Tuple t, Array sequence, Expr field1) {
        ArrayList<Sequence> vals = new ArrayList<Sequence>();
        for (Sequence value : sequence.values()) {
            Sequence sequenceByRecordField;
            Sequence val = value.evaluate(ctx, t);
            if (val instanceof Array) {
                vals.addAll(this.getSequenceValues(ctx, t, (Array)val, field1));
                continue;
            }
            if (!(val instanceof Record)) continue;
            Record record = (Record)val;
            Item field = field1.evaluateToItem(ctx, t);
            if (field == null || (sequenceByRecordField = this.getSequenceByRecordField(record, field)) == null) continue;
            vals.add(sequenceByRecordField);
        }
        return vals;
    }

    private Sequence getSequenceByRecordField(Record record, Item field) {
        Sequence sequence;
        if (field instanceof QNm) {
            sequence = record.get((QNm)field);
        } else if (field instanceof IntNumeric) {
            sequence = record.value((IntNumeric)field);
        } else if (field instanceof Atomic) {
            sequence = record.get(new QNm(((Atomic)field).asStr().toString()));
        } else {
            throw new QueryException(Bits.BIT_ILLEGAL_RECORD_FIELD, "Illegal record field reference: %s", field);
        }
        return sequence;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        if (this.record.isUpdating()) {
            return true;
        }
        for (Expr f : this.fields) {
            if (!f.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Expr f : this.fields) {
            s.append("=>");
            s.append(f);
        }
        return s.toString();
    }

    public static void main(String[] args) {
        new XQuery("let $n := <x><y>yval</y></x> return { \"e\" : { \"m\": \"mvalue\", \"n\":$n}}=>e=>n/y").serialize((QueryContext)new BrackitQueryContext(), System.out);
    }
}

