/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.expr.ConstructedNodeBuilder;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;

public class ElementExpr
extends ConstructedNodeBuilder
implements Expr {
    protected final StaticContext sctx;
    protected final Expr nameExpr;
    protected final NS[] namespaces;
    protected final Expr[] contentExprs;
    protected final boolean bind;
    protected final boolean appendOnly;
    protected final QNm name;

    public ElementExpr(StaticContext sctx, Expr nameExpr, NS[] namespaces, Expr[] contentExpr, boolean bind, boolean appendOnly) {
        this.sctx = sctx;
        this.nameExpr = nameExpr;
        this.namespaces = namespaces;
        this.contentExprs = contentExpr;
        this.bind = bind;
        this.appendOnly = appendOnly;
        this.name = (QNm)(nameExpr instanceof QNm ? nameExpr : null);
    }

    @Override
    public final Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        QNm name = this.name != null ? this.name : this.buildElementName(this.sctx, this.nameExpr.evaluateToItem(ctx, tuple));
        Object element = this.appendOnly ? ((Node)tuple.get(tuple.getSize() - 1)).append(Kind.ELEMENT, name, null) : ctx.getNodeFactory().element(name);
        for (NS ns : this.namespaces) {
            String prefix = ns.getPrefix();
            String uri = ns.getURI();
            if (prefix == null) {
                element.getScope().setDefaultNS(uri);
                continue;
            }
            element.getScope().addPrefix(prefix, uri);
        }
        String nsURI = name.getNamespaceURI();
        String prefix = name.getPrefix();
        if (prefix != null && element.getScope().resolvePrefix(prefix) == null) {
            element.getScope().addPrefix(prefix, nsURI);
        } else if (!nsURI.isEmpty() && !nsURI.equals(element.getScope().defaultNS())) {
            element.getScope().setDefaultNS(nsURI);
        }
        ConstructedNodeBuilder.ContentSink sink = new ConstructedNodeBuilder.ContentSink(){
            final /* synthetic */ Node val$element;
            {
                this.val$element = node;
            }

            @Override
            public Node<?> addNode(QueryContext ctx, Node<?> node) {
                return this.val$element.append(node);
            }

            @Override
            public Node<?> addAttribute(QueryContext ctx, Node<?> attribute) {
                return this.val$element.setAttribute(attribute);
            }
        };
        Tuple t = this.bind ? tuple.concat((Sequence)element) : tuple;
        for (int i = 0; i < this.contentExprs.length; ++i) {
            Sequence content = this.contentExprs[i].evaluate(ctx, t);
            this.buildContentSequence(ctx, sink, content);
        }
        return this.appendOnly ? null : element;
    }

    @Override
    public boolean isUpdating() {
        boolean updating = this.nameExpr.isUpdating();
        int i = 0;
        while (!updating && i < this.contentExprs.length) {
            updating = this.contentExprs[i++].isUpdating();
        }
        return updating;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return "element";
    }

    public static class NS {
        private final String prefix;
        private final String uri;

        public NS(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getURI() {
            return this.uri;
        }
    }
}

