/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.expr.VCmpExpr;
import org.brackit.xquery.util.Cmp;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;

public class GCmpExpr
extends VCmpExpr {
    public GCmpExpr(Cmp cmp, Expr leftExpr, Expr rightExpr) {
        super(cmp, leftExpr, rightExpr);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence left = this.leftExpr.evaluate(ctx, tuple);
        Sequence right = this.rightExpr.evaluate(ctx, tuple);
        return this.cmp.gCmpAsBool(ctx, left, right);
    }

    @Override
    public String toString() {
        return this.leftExpr + " " + this.toGcmpString(this.cmp) + " " + this.rightExpr;
    }

    private String toGcmpString(Cmp cmp) {
        return switch (cmp) {
            case Cmp.eq -> "=";
            case Cmp.ne -> "!=";
            case Cmp.ge -> ">=";
            case Cmp.gt -> ">";
            case Cmp.le -> "<=";
            case Cmp.lt -> "<";
            default -> ">=";
        };
    }
}

