/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;

public class IfExpr
implements Expr {
    private final Expr condExpr;
    private final Expr ifExpr;
    private final Expr elseExpr;

    public IfExpr(Expr condExpr, Expr ifExpr, Expr elseExpr) {
        this.condExpr = condExpr;
        this.ifExpr = ifExpr;
        this.elseExpr = elseExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence cond = this.condExpr.evaluate(ctx, tuple);
        return cond != null && cond.booleanValue() ? this.ifExpr.evaluate(ctx, tuple) : this.elseExpr.evaluate(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence cond = this.condExpr.evaluate(ctx, tuple);
        return cond != null && cond.booleanValue() ? this.ifExpr.evaluateToItem(ctx, tuple) : this.elseExpr.evaluateToItem(ctx, tuple);
    }

    @Override
    public boolean isUpdating() {
        return this.ifExpr.isUpdating() || this.elseExpr.isUpdating() || this.condExpr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return this.ifExpr.isVacuous() && this.elseExpr.isVacuous();
    }
}

