/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Bool;
import org.brackit.xquery.sequence.TypedSequence;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.type.SequenceType;

public class InstanceOf
implements Expr {
    private final Expr expr;
    private final SequenceType expected;

    public InstanceOf(Expr expr, SequenceType expected) {
        this.expr = expr;
        this.expected = expected;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        try {
            Sequence sequence = this.expr.evaluate(ctx, tuple);
            if (sequence instanceof Item) {
                TypedSequence.toTypedItem(this.expected, (Item)sequence);
            } else {
                Sequence typed = TypedSequence.toTypedSequence(this.expected, sequence);
                if (typed != null) {
                    try (Iter it = typed.iterate();){
                        while (it.next() != null) {
                        }
                    }
                }
            }
            return Bool.TRUE;
        }
        catch (QueryException e) {
            if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                return Bool.FALSE;
            }
            throw e;
        }
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

