/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Bool;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;

public class OrExpr
implements Expr {
    private final Expr firstExpr;
    private final Expr secondExpr;

    public OrExpr(Expr firstExpr, Expr secondExpr) {
        this.firstExpr = firstExpr;
        this.secondExpr = secondExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence firstResult = this.firstExpr.evaluate(ctx, tuple);
        if (firstResult != null && firstResult.booleanValue()) {
            return Bool.TRUE;
        }
        Sequence secondResult = this.secondExpr.evaluate(ctx, tuple);
        return secondResult != null && secondResult.booleanValue() ? Bool.TRUE : Bool.FALSE;
    }

    @Override
    public boolean isUpdating() {
        return this.firstExpr.isUpdating() || this.secondExpr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

