/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import java.util.Comparator;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.util.ExprUtil;
import org.brackit.xquery.util.sort.TupleSort;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.node.Node;

public class PathStepExpr
implements Expr {
    final Expr e2;
    final Expr e1;
    final boolean bindItem;
    final boolean bindPos;
    final boolean bindSize;
    final int bindCount;
    final boolean lastStep;
    final boolean skipDDO;
    final boolean checkInput;

    public PathStepExpr(Expr e1, Expr e2, boolean bindItem, boolean bindPos, boolean bindSize, boolean lastStep, boolean skipDDO, boolean checkInput) {
        this.e1 = e1;
        this.e2 = e2;
        this.bindItem = bindItem;
        this.bindPos = bindPos;
        this.bindSize = bindSize;
        this.lastStep = lastStep;
        this.skipDDO = skipDDO;
        this.checkInput = checkInput;
        this.bindCount = (bindItem ? 1 : 0) + (bindPos ? 1 : 0) + (bindSize ? 1 : 0);
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple t) {
        Sequence in = this.e1.evaluate(ctx, t);
        if (!this.skipDDO && this.checkInput) {
            in = ExprUtil.materialize(in);
        }
        if (in == null) {
            return null;
        }
        IntNumeric size = this.bindSize ? in.size() : null;
        LazySequence out = new PathStepSequence(ctx, t, in, size);
        if (!(this.skipDDO || this.checkInput && in instanceof Node)) {
            out = new DdoOrAtomicSequence(out);
        }
        return out;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        return this.e1.isUpdating() || this.e2.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return this.e1 + "/" + this.e2;
    }

    private class PathStepSequence
    extends LazySequence {
        final QueryContext ctx;
        final Sequence in;
        final Tuple t;
        final IntNumeric s;

        PathStepSequence(QueryContext ctx, Tuple t, Sequence in, IntNumeric s) {
            this.ctx = ctx;
            this.t = t;
            this.in = in;
            this.s = s;
        }

        @Override
        public Iter iterate() {
            if (this.in instanceof Item) {
                return new ItemContextPathStepIter(this.ctx, this.t, (Item)this.in);
            }
            return new SequenceContextPathStepIter(this.ctx, this.t, this.s, this.in.iterate());
        }

        public String toString() {
            return PathStepExpr.this.e1 + "/" + PathStepExpr.this.e2;
        }
    }

    private static class DdoOrAtomicSequence
    extends LazySequence {
        static final Comparator<Tuple> cmp = (o1, o2) -> ((Node)o1).cmp((Node)o2);
        final Sequence s;
        volatile TupleSort tupleSort;
        volatile boolean atomicOnly;

        public DdoOrAtomicSequence(Sequence s) {
            this.s = s;
        }

        @Override
        public Iter iterate() {
            return new BaseIter(){
                Iter it;
                Stream<? extends Tuple> sorted;
                Node<?> prev = null;

                @Override
                public Item next() {
                    Item next;
                    if (atomicOnly) {
                        if (this.it == null) {
                            this.it = s.iterate();
                        }
                        return this.it.next();
                    }
                    TupleSort sort = tupleSort;
                    if (sort == null) {
                        this.it = s.iterate();
                        next = this.it.next();
                        if (next == null) {
                            atomicOnly = true;
                            return null;
                        }
                        if (next instanceof Atomic) {
                            atomicOnly = true;
                            return next;
                        }
                        try {
                            sort = new TupleSort(cmp, -1L);
                            do {
                                sort.add(next);
                            } while ((next = this.it.next()) != null);
                            sort.sort();
                            tupleSort = sort;
                        }
                        finally {
                            this.it.close();
                            this.it = null;
                        }
                    }
                    if (this.sorted == null) {
                        this.sorted = sort.stream();
                    }
                    while ((next = (Node)this.sorted.next()) != null) {
                        if (this.prev != null && this.prev.cmp((Node<?>)next) == 0) continue;
                        this.prev = next;
                        return next;
                    }
                    return null;
                }

                @Override
                public void close() {
                    if (this.sorted != null) {
                        this.sorted.close();
                    }
                    if (this.it != null) {
                        this.it.close();
                    }
                }
            };
        }
    }

    private class SequenceContextPathStepIter
    extends BaseIter {
        final QueryContext ctx;
        final Tuple tuple;
        final IntNumeric inSeqSize;
        final Iter in;
        Boolean nodeOnly;
        IntNumeric pos = Int32.ZERO;
        Iter out;

        SequenceContextPathStepIter(QueryContext ctx, Tuple tuple, IntNumeric inSeqSize, Iter in) {
            this.ctx = ctx;
            this.tuple = tuple;
            this.inSeqSize = inSeqSize;
            this.in = in;
        }

        @Override
        public Item next() {
            while (true) {
                Sequence s;
                if (this.out != null) {
                    Item next = this.out.next();
                    if (next != null) {
                        if (this.nodeOnly == null) {
                            this.nodeOnly = next instanceof Node;
                        } else if (PathStepExpr.this.lastStep && this.nodeOnly ^ next instanceof Node) {
                            throw new QueryException(ErrorCode.ERR_PATH_STEP_RETURNED_NODE_AND_NON_NODE_VALUES, "Path step returned both nodes and non-node values");
                        }
                        return next;
                    }
                    this.out.close();
                    this.out = null;
                }
                Tuple current = this.tuple;
                Item item = this.in.next();
                if (item == null) {
                    return null;
                }
                if (!(item instanceof Node)) {
                    throw new QueryException(ErrorCode.ERR_PATH_STEP_RETURNED_NON_NODE_VALUE, "Intermediate step in path expression returned a non-node: %s", item.itemType());
                }
                if (PathStepExpr.this.bindCount > 0) {
                    Sequence[] tmp = new Sequence[PathStepExpr.this.bindCount];
                    int p = 0;
                    if (PathStepExpr.this.bindItem) {
                        tmp[p++] = item;
                    }
                    if (PathStepExpr.this.bindPos) {
                        int n = p++;
                        this.pos = this.pos.inc();
                        tmp[n] = this.pos;
                    }
                    if (PathStepExpr.this.bindSize) {
                        tmp[p] = this.inSeqSize;
                    }
                    current = current.concat(tmp);
                }
                this.out = (s = PathStepExpr.this.e2.evaluate(this.ctx, current)) != null ? s.iterate() : null;
            }
        }

        @Override
        public void close() {
            this.in.close();
            if (this.out != null) {
                this.out.close();
            }
        }
    }

    private class ItemContextPathStepIter
    extends BaseIter {
        final QueryContext ctx;
        final Tuple t;
        final Item item;
        Boolean nodeOnly;
        Iter out;

        ItemContextPathStepIter(QueryContext ctx, Tuple t, Item item) {
            this.ctx = ctx;
            this.t = t;
            this.item = item;
        }

        @Override
        public Item next() {
            Item next;
            if (this.out == null) {
                if (this.nodeOnly != null) {
                    return null;
                }
                Sequence s = this.performStep();
                if (s == null) {
                    this.nodeOnly = Boolean.TRUE;
                    return null;
                }
                this.out = s.iterate();
            }
            if ((next = this.out.next()) != null) {
                if (this.nodeOnly == null) {
                    this.nodeOnly = next instanceof Node;
                } else if (PathStepExpr.this.lastStep && this.nodeOnly ^ next instanceof Node) {
                    throw new QueryException(ErrorCode.ERR_PATH_STEP_RETURNED_NODE_AND_NON_NODE_VALUES, "Path step returned both nodes and non-node values");
                }
            }
            return next;
        }

        private Sequence performStep() {
            if (!(this.item instanceof Node)) {
                throw new QueryException(ErrorCode.ERR_PATH_STEP_RETURNED_NON_NODE_VALUE, "Intermediate step in path expression returned a non-node: %s", this.item.itemType());
            }
            Tuple current = this.t;
            if (PathStepExpr.this.bindCount > 0) {
                Sequence[] tmp = new Sequence[PathStepExpr.this.bindCount];
                int p = 0;
                if (PathStepExpr.this.bindItem) {
                    tmp[p++] = this.item;
                }
                if (PathStepExpr.this.bindPos) {
                    tmp[p++] = Int32.ONE;
                }
                if (PathStepExpr.this.bindSize) {
                    tmp[p] = Int32.ONE;
                }
                current = current.concat(tmp);
            }
            return PathStepExpr.this.e2.evaluate(this.ctx, current);
        }

        @Override
        public void close() {
            if (this.out != null) {
                this.out.close();
            }
        }
    }
}

