/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.operator.Cursor;
import org.brackit.xquery.operator.Operator;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.util.ExprUtil;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;

public class PipeExpr
implements Expr {
    private final Operator op;
    private final Expr expr;

    public PipeExpr(Operator op, Expr expr) {
        this.op = op;
        this.expr = expr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return new PipeSequence(ctx, this.op, this.expr, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        return this.expr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        return PipeExpr.class.getSimpleName();
    }

    public static class PipeSequence
    extends LazySequence {
        final QueryContext ctx;
        final Operator op;
        final Expr expr;
        final Tuple tuple;

        public PipeSequence(QueryContext ctx, Operator op, Expr expr, Tuple tuple) {
            this.ctx = ctx;
            this.op = op;
            this.expr = expr;
            this.tuple = tuple;
        }

        @Override
        public Iter iterate() {
            return new BaseIter(){
                Cursor cursor;
                Iter it;

                @Override
                public Item next() {
                    while (true) {
                        if (this.it != null) {
                            Item i = this.it.next();
                            if (i != null) {
                                return i;
                            }
                            this.it.close();
                            this.it = null;
                        } else if (this.cursor == null) {
                            this.cursor = op.create(ctx, tuple);
                            this.cursor.open(ctx);
                        }
                        Tuple t = this.cursor.next(ctx);
                        if (t == null) {
                            return null;
                        }
                        Sequence s = expr.evaluate(ctx, t);
                        if (s == null) continue;
                        if (s instanceof Item) {
                            return (Item)s;
                        }
                        this.it = s.iterate();
                    }
                }

                @Override
                public void close() {
                    if (this.it != null) {
                        this.it.close();
                    }
                    if (this.cursor != null) {
                        this.cursor.close(ctx);
                    }
                }
            };
        }
    }
}

