/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.BrackitQueryContext;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.Bits;
import org.brackit.xquery.record.ArrayRecord;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.json.Record;

public final class ProjectionExpr
implements Expr {
    private final Expr record;
    private final Expr[] fields;

    public ProjectionExpr(Expr record, Expr[] fields) {
        this.record = record;
        this.fields = fields;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple t) {
        return this.evaluateToItem(ctx, t);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple t) {
        Item s = this.record.evaluateToItem(ctx, t);
        if (!(s instanceof Record)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Source expression in projection is not a record: %s", s);
        }
        Record r = (Record)s;
        QNm[] names = new QNm[this.fields.length];
        Sequence[] vals = new Sequence[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            Item f = this.fields[i].evaluateToItem(ctx, t);
            if (f == null) {
                return null;
            }
            if (f instanceof QNm) {
                names[i] = (QNm)f;
                vals[i] = r.get((QNm)f);
                continue;
            }
            if (f instanceof IntNumeric) {
                names[i] = r.name(i);
                vals[i] = r.value((IntNumeric)f);
                continue;
            }
            if (f instanceof Atomic) {
                QNm name;
                names[i] = name = new QNm(((Atomic)f).asStr().toString());
                vals[i] = r.get(name);
                continue;
            }
            throw new QueryException(Bits.BIT_ILLEGAL_RECORD_FIELD, "Illegal record field reference: %s", f);
        }
        return new ArrayRecord(names, vals);
    }

    @Override
    public boolean isUpdating() {
        if (this.record.isUpdating()) {
            return true;
        }
        for (Expr f : this.fields) {
            if (!f.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Expr f : this.fields) {
            s.append("=>");
            s.append(f);
        }
        return s.toString();
    }

    public static void main(String[] args) {
        new XQuery("let $a:= 1 let $b:= {'b':2.0} let $n := <x><y>yval</y></x> return {a:$a, $b, c:'3'}{a,c}=>c").serialize((QueryContext)new BrackitQueryContext(), System.out);
    }
}

