/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.brackit.xquery.BrackitQueryContext;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.compiler.Bits;
import org.brackit.xquery.record.ArrayRecord;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.json.Record;

public class RecordExpr
implements Expr {
    final Field[] fields;

    public RecordExpr(Field[] fields) {
        this.fields = fields;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple t) {
        return this.evaluateToItem(ctx, t);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple t) {
        HashSet<QNm> dedup = new HashSet<QNm>();
        QNm[] names = new QNm[this.fields.length];
        Sequence[] vals = new Sequence[this.fields.length];
        int pos = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            Record res = this.fields[i].evaluate(ctx, t);
            for (int j = 0; j < res.len(); ++j) {
                QNm name = res.name(j);
                if (!dedup.add(name)) {
                    throw new QueryException(Bits.BIT_DUPLICATE_RECORD_FIELD, "Duplicate field name: %s", name);
                }
                Sequence val = res.value(j);
                if (pos == names.length) {
                    names = Arrays.copyOfRange(names, 0, names.length * 3 / 2 + 1);
                    vals = Arrays.copyOfRange(vals, 0, vals.length * 3 / 2 + 1);
                }
                names[pos] = name;
                vals[pos] = val;
                ++pos;
            }
        }
        if (pos < names.length) {
            names = Arrays.copyOfRange(names, 0, pos);
            vals = Arrays.copyOfRange(vals, 0, pos);
        }
        return new ArrayRecord(names, vals);
    }

    @Override
    public boolean isUpdating() {
        for (Field e : this.fields) {
            if (!e.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        for (Field e : this.fields) {
            if (e.isVacuous()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        boolean first = true;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!first) {
                out.append(", ");
            }
            first = false;
            out.append(this.fields[i].toString());
        }
        out.append("]");
        return out.toString();
    }

    public static void main(String[] args) {
        new XQuery("{ a:1, b:2, c:3 , {x:1}, y:5, z : {foo : 'bar'}, 'aha' : 2, 'h h' : 5 }").serialize((QueryContext)new BrackitQueryContext(), System.out);
    }

    public static abstract class Field {
        abstract Record evaluate(QueryContext var1, Tuple var2) throws QueryException;

        abstract boolean isUpdating();

        boolean isVacuous() {
            return false;
        }
    }

    public static class KeyValueField
    extends Field {
        final Expr nameExpr;
        final Expr valueExpr;

        public KeyValueField(Expr name, Expr expr) {
            this.nameExpr = name;
            this.valueExpr = expr;
        }

        @Override
        public Record evaluate(QueryContext ctx, Tuple t) {
            Item names = this.nameExpr.evaluateToItem(ctx, t);
            Item val = this.valueExpr.evaluateToItem(ctx, t);
            if (names instanceof Str) {
                return new ArrayRecord(new QNm[]{new QNm(((Str)names).stringValue())}, new Sequence[]{val});
            }
            return new ArrayRecord(new QNm[]{(QNm)names.get(0)}, new Sequence[]{val});
        }

        @Override
        boolean isUpdating() {
            return this.valueExpr.isUpdating();
        }
    }

    public static class RecordField
    extends Field {
        final Expr expr;

        public RecordField(Expr expr) {
            this.expr = expr;
        }

        @Override
        public Record evaluate(QueryContext ctx, Tuple t) {
            Item item;
            Sequence i = this.expr.evaluate(ctx, t);
            if (i instanceof Record) {
                return (Record)i;
            }
            ArrayList names = new ArrayList();
            ArrayList values = new ArrayList();
            Iter iter = i.iterate();
            while ((item = iter.next()) != null) {
                if (!(item instanceof Record)) {
                    throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal item type in record constructor: %s", item.itemType());
                }
                Record record = (Record)item;
                Collections.addAll(names, record.names().values().toArray(new QNm[0]));
                Collections.addAll(values, record.values().values().toArray(new Sequence[0]));
            }
            return new ArrayRecord(names.toArray(new QNm[0]), values.toArray(new Sequence[0]));
        }

        @Override
        boolean isUpdating() {
            return this.expr.isUpdating();
        }
    }
}

