/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import java.util.List;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.array.DArray;
import org.brackit.xquery.sequence.FlatteningSequence;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.magicwerk.brownies.collections.GapList;

public final class SequenceExpr
implements Expr {
    final Expr[] expr;

    public SequenceExpr(Expr ... expr) {
        this.expr = expr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return new EvalSequence(tuple, ctx);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        if (this.expr.length == 0) {
            return null;
        }
        if (this.expr.length == 1) {
            return this.expr[0].evaluateToItem(ctx, tuple);
        }
        int i = 0;
        Item res = null;
        while (i < this.expr.length && (res = this.expr[i++].evaluateToItem(ctx, tuple)) == null) {
        }
        if (i == this.expr.length) {
            return res;
        }
        GapList sequence = new GapList(this.expr.length);
        for (Expr value : this.expr) {
            sequence.add((Object)value.evaluateToItem(ctx, tuple));
        }
        return new DArray((List<? extends Sequence>)sequence);
    }

    @Override
    public boolean isUpdating() {
        for (Expr e : this.expr) {
            if (!e.isUpdating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        for (Expr e : this.expr) {
            if (e.isVacuous()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("(");
        boolean first = true;
        for (Expr e : this.expr) {
            if (!first) {
                out.append(", ");
            }
            first = false;
            out.append(e.toString());
        }
        out.append(")");
        return out.toString();
    }

    public final class EvalSequence
    extends FlatteningSequence {
        final Tuple tuple;
        final QueryContext ctx;
        final Sequence[] seqs;
        int eval;

        private EvalSequence(Tuple tuple, QueryContext ctx) {
            this.tuple = tuple;
            this.ctx = ctx;
            this.seqs = new Sequence[SequenceExpr.this.expr.length];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Sequence sequence(int pos) {
            if (pos >= SequenceExpr.this.expr.length) {
                return null;
            }
            Sequence s = this.seqs[pos];
            if (s != null) {
                return s;
            }
            Sequence[] sequenceArray = this.seqs;
            synchronized (this.seqs) {
                while (s == null && this.eval < SequenceExpr.this.expr.length) {
                    s = this.seqs[pos] = SequenceExpr.this.expr[this.eval++].evaluate(this.ctx, this.tuple);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return s;
            }
        }
    }
}

