/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.atomic.Numeric;
import org.brackit.xquery.expr.Accessor;
import org.brackit.xquery.expr.PredicateExpr;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.ItemSequence;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.util.ExprUtil;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.node.Node;
import org.brackit.xquery.xdm.type.NodeType;

public class StepExpr
extends PredicateExpr {
    final Accessor accessor;
    final Expr input;
    final NodeType test;

    public StepExpr(Accessor accessor, NodeType test, Expr input, Expr[] filter, boolean[] bindItem, boolean[] bindPos, boolean[] bindSize) {
        super(filter, bindItem, bindPos, bindSize);
        this.accessor = accessor;
        this.test = test;
        this.input = input;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence node = this.input.evaluate(ctx, tuple);
        if (node == null) {
            return null;
        }
        if (!(node instanceof Item)) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Context item in axis step is not an item: %s", node);
        }
        if (!(node instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_PATH_STEP_CONTEXT_ITEM_IS_NOT_A_NODE, "Context item in axis step is not a node: %s", ((Item)node).itemType());
        }
        Sequence s = new AxisStepSequence((Node)node);
        boolean backwardAxis = !this.accessor.getAxis().isForward();
        boolean reversed = false;
        for (int i = 0; i < this.filter.length; ++i) {
            if (s == null) {
                return null;
            }
            if (this.bindCount[i] == 0) {
                Sequence fs = this.filter[i].evaluate(ctx, tuple);
                if (fs == null) {
                    return null;
                }
                if (fs instanceof Numeric) {
                    IntNumeric pos = ((Numeric)fs).asIntNumeric();
                    s = pos != null ? s.get(pos) : null;
                    continue;
                }
                try (Iter it = fs.iterate();){
                    Item first = it.next();
                    if (first != null && it.next() == null && first instanceof Numeric) {
                        IntNumeric pos = ((Numeric)first).asIntNumeric();
                        Item item = pos != null ? s.get(pos) : null;
                        return item;
                    }
                }
                if (fs.booleanValue()) continue;
                return null;
            }
            if (backwardAxis && !reversed && this.bindPos[i]) {
                s = this.reverse(s);
                reversed = true;
            }
            s = new PredicateExpr.DependentFilterSeq(ctx, tuple, s, i);
        }
        if (reversed) {
            assert (s != null);
            s = this.reverse(s);
        }
        return s;
    }

    private Sequence reverse(Sequence s) {
        Item item;
        Item[] items = new Item[s.size().intValue()];
        Iter iter = s.iterate();
        int i = items.length - 1;
        while ((item = iter.next()) != null) {
            items[i--] = item;
        }
        return new ItemSequence(items);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        if (this.input.isUpdating()) {
            return true;
        }
        return super.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.accessor.toString());
        s.append("::");
        s.append(this.test.toString());
        for (int i = 0; i < this.filter.length; ++i) {
            s.append('[');
            s.append(this.filter[i]);
            s.append(']');
        }
        return s.toString();
    }

    private class AxisStepSequence
    extends LazySequence {
        final Node<?> n;

        AxisStepSequence(Node<?> n) {
            this.n = n;
        }

        @Override
        public Iter iterate() {
            return new AxisStepSequenceIter(this.n);
        }
    }

    private class AxisStepSequenceIter
    extends BaseIter {
        final Node<?> node;
        Stream<? extends Node<?>> nextS;

        AxisStepSequenceIter(Node<?> node) {
            this.node = node;
        }

        @Override
        public Item next() {
            if (this.nextS == null) {
                this.nextS = StepExpr.this.accessor.performStep(this.node, StepExpr.this.test);
            }
            return this.nextS.next();
        }

        @Override
        public void close() {
            if (this.nextS != null) {
                this.nextS.close();
            }
        }
    }
}

