/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.function.fn.DeepEqual;
import org.brackit.xquery.util.ExprUtil;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;

public class SwitchExpr
implements Expr {
    final Expr operand;
    final Expr[][] cases;
    final Expr dftValue;

    public SwitchExpr(Expr operand, Expr[][] cases, Expr dftValue) {
        this.operand = operand;
        this.cases = cases;
        this.dftValue = dftValue;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        Item oi = this.operand.evaluateToItem(ctx, tuple);
        Atomic oa = oi != null ? oi.atomize() : null;
        for (Expr[] aCase : this.cases) {
            for (int j = 0; j < aCase.length - 1; ++j) {
                Atomic ca;
                Item cij = aCase[j].evaluateToItem(ctx, tuple);
                Atomic atomic = ca = cij != null ? cij.atomize() : null;
                if (!DeepEqual.deepEquals((Sequence)oa, (Sequence)ca).booleanValue()) continue;
                return aCase[aCase.length - 1].evaluate(ctx, tuple);
            }
        }
        return this.dftValue.evaluate(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        if (this.operand.isUpdating() || this.dftValue.isUpdating()) {
            return true;
        }
        Expr[][] exprArray = this.cases;
        int n = exprArray.length;
        for (int i = 0; i < n; ++i) {
            Expr[] aCase;
            for (Expr expr : aCase = exprArray[i]) {
                if (!expr.isUpdating()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isVacuous() {
        if (this.operand.isVacuous() || this.dftValue.isVacuous()) {
            return true;
        }
        Expr[][] exprArray = this.cases;
        int n = exprArray.length;
        for (int i = 0; i < n; ++i) {
            Expr[] aCase;
            for (Expr expr : aCase = exprArray[i]) {
                if (!expr.isVacuous()) continue;
                return true;
            }
        }
        return false;
    }
}

