/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.atomic.Una;
import org.brackit.xquery.expr.ConstructedNodeBuilder;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;

public class TextExpr
extends ConstructedNodeBuilder
implements Expr {
    protected final Expr expr;
    protected final boolean appendOnly;

    public TextExpr(Expr expr, boolean appendOnly) {
        this.expr = expr;
        this.appendOnly = appendOnly;
    }

    @Override
    public final Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence sequence = this.expr.evaluate(ctx, tuple);
        StringBuilder buf = new StringBuilder();
        if (sequence != null) {
            if (sequence instanceof Item) {
                String s = ((Item)sequence).atomize().stringValue();
                buf.append(s);
            } else {
                boolean first = true;
                try (Iter it = sequence.iterate();){
                    Item item;
                    while ((item = it.next()) != null) {
                        String s = item.atomize().stringValue();
                        if (s.isEmpty()) continue;
                        if (!first) {
                            buf.append(' ');
                        }
                        first = false;
                        buf.append(s);
                    }
                }
            }
        }
        String content = buf.toString();
        if (this.appendOnly) {
            ((Node)tuple.get(tuple.getSize() - 1)).append(Kind.TEXT, null, new Str(content));
            return null;
        }
        return ctx.getNodeFactory().text(new Una(content));
    }

    @Override
    public boolean isUpdating() {
        return this.expr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

