/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.sequence.AbstractSequence;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.TypedSequence;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.type.SequenceType;

public class Treat
implements Expr {
    private final Expr expr;
    private final SequenceType expected;

    public Treat(Expr expr, SequenceType expected) {
        this.expr = expr;
        this.expected = expected;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        try {
            Sequence sequence = this.expr.evaluate(ctx, tuple);
            final Sequence typedSequence = TypedSequence.toTypedSequence(this.expected, sequence);
            return new AbstractSequence(){
                final Sequence s;
                {
                    this.s = typedSequence;
                }

                @Override
                public IntNumeric size() {
                    try {
                        return this.s.size();
                    }
                    catch (QueryException e) {
                        if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                            throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
                        }
                        throw e;
                    }
                }

                @Override
                public Iter iterate() {
                    return new BaseIter(){
                        Iter it;
                        {
                            this.it = s.iterate();
                        }

                        @Override
                        public Item next() {
                            try {
                                return this.it.next();
                            }
                            catch (QueryException e) {
                                if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                                    throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
                                }
                                throw e;
                            }
                        }

                        @Override
                        public void close() {
                            this.it.close();
                        }
                    };
                }

                @Override
                public boolean booleanValue() {
                    try {
                        return this.s.booleanValue();
                    }
                    catch (QueryException e) {
                        if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                            throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
                        }
                        throw e;
                    }
                }

                @Override
                public Item get(IntNumeric pos) {
                    try {
                        return this.s.get(pos);
                    }
                    catch (QueryException e) {
                        if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                            throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
                        }
                        throw e;
                    }
                }
            };
        }
        catch (QueryException e) {
            if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
            }
            throw e;
        }
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        try {
            Item item = this.expr.evaluateToItem(ctx, tuple);
            return TypedSequence.toTypedItem(this.expected, item);
        }
        catch (QueryException e) {
            if (e.getCode() == ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE) {
                throw new QueryException(e, ErrorCode.ERR_DYNAMIC_TYPE_DOES_NOT_MATCH_TREAT_TYPE);
            }
            throw e;
        }
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

