/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import java.util.Comparator;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.sequence.SortedNodeSequence;
import org.brackit.xquery.util.ExprUtil;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;

public class UnionExpr
implements Expr {
    private final Expr firstExpr;
    private final Expr secondExpr;

    public UnionExpr(Expr firstExpr, Expr secondExpr) {
        this.firstExpr = firstExpr;
        this.secondExpr = secondExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Sequence sequenceA = this.firstExpr.evaluate(ctx, tuple);
        Sequence sequenceB = this.secondExpr.evaluate(ctx, tuple);
        if (sequenceA == null || sequenceB == null) {
            return null;
        }
        Comparator comparator = (o1, o2) -> ((Node)o1).cmp((Node)o2);
        final SortedNodeSequence sortedA = new SortedNodeSequence(comparator, sequenceA, true);
        final SortedNodeSequence sortedB = new SortedNodeSequence(comparator, sequenceB, true);
        return new LazySequence(){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    Iter aIt;
                    Iter bIt;
                    Node<?> a;
                    Node<?> b;

                    @Override
                    public Item next() {
                        if (this.aIt == null) {
                            this.aIt = sortedA.iterate();
                            this.bIt = sortedB.iterate();
                            this.a = (Node)this.aIt.next();
                            this.b = (Node)this.bIt.next();
                        }
                        if (this.a != null && this.b != null) {
                            int res = this.a.cmp(this.b);
                            if (res == 0) {
                                Node<?> deliver = this.a;
                                this.a = (Node)this.aIt.next();
                                this.b = (Node)this.bIt.next();
                                return deliver;
                            }
                            if (res < 0) {
                                Node<?> deliver = this.a;
                                this.a = (Node)this.aIt.next();
                                return deliver;
                            }
                            Node<?> deliver = this.b;
                            this.b = (Node)this.bIt.next();
                            return deliver;
                        }
                        if (this.a != null) {
                            Node<?> deliver = this.a;
                            this.a = (Node)this.aIt.next();
                            return deliver;
                        }
                        if (this.b != null) {
                            Node<?> deliver = this.b;
                            this.b = (Node)this.bIt.next();
                            return deliver;
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                        if (this.aIt != null) {
                            this.aIt.close();
                        }
                        if (this.bIt != null) {
                            this.bIt.close();
                        }
                    }
                };
            }
        };
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this.evaluate(ctx, tuple));
    }

    @Override
    public boolean isUpdating() {
        return this.firstExpr.isUpdating() || this.secondExpr.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

