/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.xdm.AbstractItem;
import org.brackit.xquery.xdm.Function;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.type.FunctionType;
import org.brackit.xquery.xdm.type.ItemType;

public abstract class AbstractFunction
extends AbstractItem
implements Function {
    private final QNm name;
    private final Signature signature;
    private final boolean isUpdating;
    private final boolean isBuiltIn;

    public AbstractFunction(QNm name, Signature signature, boolean isBuiltIn) {
        this.name = name;
        this.signature = signature;
        this.isUpdating = false;
        this.isBuiltIn = isBuiltIn;
    }

    public AbstractFunction(QNm name, Signature signature, boolean isBuiltIn, boolean isUpating) {
        this.name = name;
        this.signature = signature;
        this.isUpdating = isUpating;
        this.isBuiltIn = isBuiltIn;
    }

    @Override
    public final QNm getName() {
        return this.name;
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isUpdating() {
        return this.isUpdating;
    }

    @Override
    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public final String toString() {
        return this.name.toString() + this.signature;
    }

    @Override
    public Atomic atomize() throws QueryException {
        throw new QueryException(ErrorCode.ERR_ITEM_HAS_NO_TYPED_VALUE, "The atomized value of function items is undefined");
    }

    @Override
    public ItemType itemType() throws QueryException {
        return new FunctionType(this.signature);
    }

    @Override
    public boolean booleanValue() throws QueryException {
        throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "The effective boolean value of function items is undefined");
    }
}

