/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.bit;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.operator.TupleImpl;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.FlatteningSequence;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.util.annotation.FunctionAnnotation;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.json.Array;
import org.brackit.xquery.xdm.type.ArrayType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.SequenceType;

@FunctionAnnotation(description="Returns the values of the given array.", parameters={"$array"})
public class ArrayValues
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "array-values");

    public ArrayValues() {
        this(DEFAULT_NAME);
    }

    public ArrayValues(QNm name) {
        super(name, new Signature(SequenceType.ITEM_SEQUENCE, new SequenceType(ArrayType.ARRAY, Cardinality.ZeroOrOne)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, final QueryContext ctx, Sequence[] args) {
        final Array array = (Array)args[0];
        if (array == null) {
            return null;
        }
        return new LazySequence(){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    private List<Sequence> sequences;
                    private Deque<Item> flatteningSequences = new ArrayDeque<Item>();
                    private int index;

                    @Override
                    public Item next() {
                        if (this.sequences == null) {
                            this.sequences = array.values();
                        } else if (!this.flatteningSequences.isEmpty()) {
                            return this.flatteningSequences.removeFirst();
                        }
                        if (this.index < this.sequences.size()) {
                            Sequence sequence;
                            if ((sequence = this.sequences.get(this.index++)) instanceof FlatteningSequence) {
                                Item item;
                                Iter iter = sequence.iterate();
                                while ((item = iter.next()) != null) {
                                    this.flatteningSequences.addLast(item.evaluateToItem(ctx, new TupleImpl()));
                                }
                                return this.flatteningSequences.removeFirst();
                            }
                            return (Item)sequence;
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }
}

