/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.bit;

import java.io.PrintStream;
import org.brackit.xquery.BrackitQueryContext;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.function.bit.BitFun;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.util.annotation.FunctionAnnotation;
import org.brackit.xquery.util.io.IOUtils;
import org.brackit.xquery.util.serialize.StringSerializer;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.type.AnyItemType;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.SequenceType;

@FunctionAnnotation(description="Executes the given query.", parameters={"$query"})
public class Eval
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "eval");

    public Eval() {
        this(DEFAULT_NAME);
    }

    public Eval(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne), new SequenceType(AnyItemType.ANY, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            String vQuery = null;
            if (args[0] instanceof Atomic) {
                vQuery = ((Atomic)args[0]).stringValue();
            } else {
                PrintStream buf = IOUtils.createBuffer();
                StringSerializer ser = new StringSerializer(buf);
                ser.serialize(args[0]);
                vQuery = buf.toString();
            }
            XQuery x = new XQuery(vQuery);
            return x.execute(new BrackitQueryContext(ctx.getNodeStore()));
        }
        catch (Exception e) {
            throw new QueryException(e, BitFun.BIT_EVAL_INT_ERROR, (Object)e.getMessage());
        }
    }
}

