/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.bit;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Bool;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.function.bit.BitFun;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.util.annotation.FunctionAnnotation;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.SequenceType;

@FunctionAnnotation(description="Checks whether a collection exists or not.", parameters={"$name"})
public class Exists
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "exists");

    public Exists() {
        this(DEFAULT_NAME);
    }

    public Exists(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.BOOL, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            String name = ((Atomic)args[0]).stringValue();
            return ctx.getNodeStore().lookup(name) != null ? Bool.TRUE : Bool.FALSE;
        }
        catch (Exception e) {
            throw new QueryException(e, BitFun.BIT_EXISTCOLLECTION_INT_ERROR, (Object)e.getMessage());
        }
    }
}

