/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.bit;

import java.io.IOException;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.function.bit.BitFun;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.node.parser.DocumentParser;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.util.annotation.FunctionAnnotation;
import org.brackit.xquery.util.io.URIHandler;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.StructuredItemCollection;
import org.brackit.xquery.xdm.node.NodeCollection;
import org.brackit.xquery.xdm.node.NodeStore;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.ElementType;
import org.brackit.xquery.xdm.type.SequenceType;

@FunctionAnnotation(description="Load (external) documents into a collection. If explicitly required or if the collection does not exist, a new collection will be created. ", parameters={"$name", "$resources", "$create-new"})
public class Load
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "load");

    public Load(boolean createNew) {
        this(DEFAULT_NAME, createNew);
    }

    public Load(QNm name, boolean createNew) {
        super(name, createNew ? new Signature(new SequenceType(ElementType.ELEMENT, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany)) : new Signature(new SequenceType(ElementType.ELEMENT, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.BOOL, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            boolean createNew = args.length != 3 ? true : ((Atomic)args[2]).booleanValue();
            String name = ((Atomic)args[0]).stringValue();
            Sequence resources = args[1];
            NodeStore s = ctx.getNodeStore();
            if (createNew) {
                this.create(s, name, resources);
            } else {
                try {
                    StructuredItemCollection coll = s.lookup(name);
                    this.add(s, (NodeCollection<?>)coll, resources);
                }
                catch (DocumentException e) {
                    this.create(s, name, resources);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new QueryException(e, BitFun.BIT_ADDTOCOLLECTION_INT_ERROR, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(NodeStore store, NodeCollection<?> coll, Sequence resources) throws DocumentException, IOException {
        if (resources instanceof Atomic) {
            String r = ((Atomic)resources).stringValue();
            coll.add(new DocumentParser(URIHandler.getInputStream(r)));
        } else {
            try (ParserStream parsers = new ParserStream(resources);){
                SubtreeParser parser;
                while ((parser = parsers.next()) != null) {
                    coll.add(parser);
                }
            }
        }
    }

    private void create(NodeStore store, String name, Sequence resources) throws DocumentException, IOException {
        if (resources instanceof Atomic) {
            String r = ((Atomic)resources).stringValue();
            store.create(name, new DocumentParser(URIHandler.getInputStream(r)));
        } else {
            store.create(name, new ParserStream(resources));
        }
    }

    private static class ParserStream
    implements Stream<SubtreeParser> {
        Iter it;

        public ParserStream(Sequence locs) {
            this.it = locs.iterate();
        }

        @Override
        public SubtreeParser next() throws DocumentException {
            try {
                Item i = this.it.next();
                if (i == null) {
                    return null;
                }
                if (i instanceof Atomic) {
                    String s = ((Atomic)i).stringValue();
                    return new DocumentParser(URIHandler.getInputStream(s));
                }
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot create subtree parser for item of type: %s", i.itemType());
            }
            catch (IOException e) {
                throw new DocumentException(e);
            }
            catch (QueryException e) {
                throw new DocumentException(e);
            }
        }

        @Override
        public void close() {
            this.it.close();
        }
    }
}

