/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.bit;

import java.util.Calendar;
import java.util.TimeZone;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractTimeInstant;
import org.brackit.xquery.atomic.Int64;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.util.annotation.FunctionAnnotation;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.SequenceType;

@FunctionAnnotation(description="Returns the milliseconds since 1970/01/01.", parameters={""})
public class Now
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "now");

    public Now() {
        this(DEFAULT_NAME);
    }

    public Now(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.INT, Cardinality.One), new SequenceType[0]), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            AbstractTimeInstant dateTime = ctx.getDateTime().canonicalize();
            int millis = dateTime.getMicros() % 1000000 / 1000;
            int seconds = dateTime.getMicros() / 1000000;
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.set(1, dateTime.getYear());
            cal.set(2, dateTime.getMonth() - 1);
            cal.set(11, dateTime.getHours());
            cal.set(12, dateTime.getMinutes());
            cal.set(13, seconds);
            cal.set(14, millis);
            long currentMillis = cal.getTimeInMillis();
            return new Int64(currentMillis);
        }
        catch (Exception e) {
            throw new QueryException(e, ErrorCode.BIT_DYN_INT_ERROR);
        }
    }
}

