/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.bit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.Int64;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.util.serialize.StringSerializer;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.SequenceType;

public class Silent
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "silent");

    public Silent() {
        this(DEFAULT_NAME);
    }

    public Silent(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.INR, Cardinality.One), SequenceType.ITEM_SEQUENCE), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        Sequence sequence = args[0];
        if (sequence == null) {
            return Int32.ZERO;
        }
        CountStream out = new CountStream();
        new StringSerializer(new PrintWriter(out)).serialize(sequence);
        return new Int64(out.count);
    }

    private static class CountStream
    extends OutputStream {
        long count = 0L;

        private CountStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.count;
        }
    }
}

