/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.bit;

import java.io.IOException;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.function.bit.BitFun;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.node.parser.StreamSubtreeParser;
import org.brackit.xquery.node.parser.SubtreeHandler;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.util.annotation.FunctionAnnotation;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.StructuredItemCollection;
import org.brackit.xquery.xdm.node.Node;
import org.brackit.xquery.xdm.node.NodeCollection;
import org.brackit.xquery.xdm.node.NodeStore;
import org.brackit.xquery.xdm.type.AnyNodeType;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.ElementType;
import org.brackit.xquery.xdm.type.SequenceType;

@FunctionAnnotation(description="Store the given fragments in a collection. If explicitly required or if the collection does not exist, a new collection will be created. ", parameters={"$name", "$fragments", "$create-new"})
public class Store
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/bit", "bit", "store");

    public Store(boolean createNew) {
        this(DEFAULT_NAME, createNew);
    }

    public Store(QNm name, boolean createNew) {
        super(name, createNew ? new Signature(new SequenceType(ElementType.ELEMENT, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrMany)) : new Signature(new SequenceType(ElementType.ELEMENT, Cardinality.ZeroOrOne), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AnyNodeType.ANY_NODE, Cardinality.ZeroOrMany), new SequenceType(AtomicType.BOOL, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            boolean createNew = args.length != 3 ? true : ((Atomic)args[2]).booleanValue();
            String name = ((Atomic)args[0]).stringValue();
            Sequence nodes = args[1];
            NodeStore s = ctx.getNodeStore();
            if (createNew) {
                this.create(s, name, nodes);
            } else {
                try {
                    StructuredItemCollection coll = s.lookup(name);
                    this.add(s, (NodeCollection<?>)coll, nodes);
                }
                catch (DocumentException e) {
                    this.create(s, name, nodes);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new QueryException(e, BitFun.BIT_ADDTOCOLLECTION_INT_ERROR, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(NodeStore store, NodeCollection<?> coll, Sequence nodes) throws DocumentException, IOException {
        if (nodes instanceof Node) {
            Node n = (Node)nodes;
            coll.add(new StoreParser(n));
        } else {
            try (ParserStream parsers = new ParserStream(nodes);){
                SubtreeParser parser;
                while ((parser = parsers.next()) != null) {
                    coll.add(parser);
                }
            }
        }
    }

    private void create(NodeStore store, String name, Sequence nodes) throws DocumentException, IOException {
        if (nodes instanceof Node) {
            Node n = (Node)nodes;
            store.create(name, new StoreParser(n));
        } else {
            store.create(name, new ParserStream(nodes));
        }
    }

    private static class StoreParser
    extends StreamSubtreeParser {
        private final boolean intercept;

        public StoreParser(Node<?> node) throws DocumentException {
            super(node.getSubtree());
            this.intercept = node.getKind() != Kind.DOCUMENT;
        }

        @Override
        public void parse(SubtreeHandler handler) throws DocumentException {
            if (this.intercept) {
                handler = new InterceptorHandler(handler);
            }
            super.parse(handler);
        }
    }

    private static class ParserStream
    implements Stream<SubtreeParser> {
        Iter it;

        public ParserStream(Sequence locs) {
            this.it = locs.iterate();
        }

        @Override
        public SubtreeParser next() throws DocumentException {
            try {
                Item i = this.it.next();
                if (i == null) {
                    return null;
                }
                if (i instanceof Node) {
                    Node n = (Node)i;
                    return new StoreParser(n);
                }
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot create subtree parser for item of type: %s", i.itemType());
            }
            catch (QueryException e) {
                throw new DocumentException(e);
            }
        }

        @Override
        public void close() {
            this.it.close();
        }
    }

    private static class InterceptorHandler
    implements SubtreeHandler {
        private final SubtreeHandler handler;

        public InterceptorHandler(SubtreeHandler handler) {
            this.handler = handler;
        }

        @Override
        public void beginFragment() throws DocumentException {
            this.handler.beginFragment();
            this.handler.startDocument();
        }

        @Override
        public void endFragment() throws DocumentException {
            this.handler.endDocument();
            this.handler.endFragment();
        }

        @Override
        public void startDocument() throws DocumentException {
            this.handler.startDocument();
        }

        @Override
        public void endDocument() throws DocumentException {
            this.handler.endDocument();
        }

        @Override
        public void text(Atomic content) throws DocumentException {
            this.handler.text(content);
        }

        @Override
        public void comment(Atomic content) throws DocumentException {
            this.handler.comment(content);
        }

        @Override
        public void processingInstruction(QNm target, Atomic content) throws DocumentException {
            this.handler.processingInstruction(target, content);
        }

        @Override
        public void startMapping(String prefix, String uri) throws DocumentException {
            this.handler.startMapping(prefix, uri);
        }

        @Override
        public void endMapping(String prefix) throws DocumentException {
            this.handler.endMapping(prefix);
        }

        @Override
        public void startElement(QNm name) throws DocumentException {
            this.handler.startElement(name);
        }

        @Override
        public void endElement(QNm name) throws DocumentException {
            this.handler.endElement(name);
        }

        @Override
        public void attribute(QNm name, Atomic value) throws DocumentException {
            this.handler.attribute(name, value);
        }

        @Override
        public void begin() throws DocumentException {
            this.handler.begin();
        }

        @Override
        public void end() throws DocumentException {
            this.handler.end();
        }

        @Override
        public void fail() throws DocumentException {
            this.handler.fail();
        }
    }
}

