/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.DTD;
import org.brackit.xquery.atomic.Date;
import org.brackit.xquery.atomic.DateTime;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Time;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class AdjustToTimezone
extends AbstractFunction {
    private Source source;

    public AdjustToTimezone(QNm name, Source source, Signature signature) {
        super(name, signature, true);
        this.source = source;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        DTD timezone;
        if (args.length == 0 || args[0] == null) {
            return null;
        }
        if (args.length > 1) {
            timezone = (DTD)args[1];
            if (timezone != null && (timezone.getMinutes() != 0 || timezone.getDays() != 0 || timezone.getHours() > 14)) {
                throw new QueryException(ErrorCode.ERR_INVALID_TIMEZONE, "Invalid value for timezone.");
            }
        } else {
            timezone = ctx.getImplicitTimezone();
        }
        switch (this.source) {
            case DATE_TIME: {
                DateTime dtNew;
                DateTime dt = (DateTime)args[0];
                if (dt.getTimezone() == null && timezone == null) {
                    dtNew = dt;
                } else if (dt.getTimezone() == null) {
                    dtNew = new DateTime(dt.getYear(), dt.getMonth(), dt.getDay(), dt.getHours(), dt.getMinutes(), dt.getMicros(), timezone);
                } else if (timezone == null) {
                    dtNew = new DateTime(dt.getYear(), dt.getMonth(), dt.getDay(), dt.getHours(), dt.getMinutes(), dt.getMicros(), null);
                } else {
                    int diff;
                    byte old = dt.getTimezone().getHours();
                    if (dt.getTimezone().isNegative()) {
                        old = (byte)(old * -1);
                    }
                    byte nw = timezone.getHours();
                    if (timezone.isNegative()) {
                        nw = (byte)(nw * -1);
                    }
                    if ((diff = nw - old) == 0) {
                        return dt;
                    }
                    dtNew = dt.add(new DTD(diff < 0, 0, (byte)Math.abs(diff), 0, 0));
                    dtNew = new DateTime(dtNew.getYear(), dtNew.getMonth(), dtNew.getDay(), dtNew.getHours(), dtNew.getMinutes(), dtNew.getMicros(), timezone);
                }
                return dtNew;
            }
            case DATE: {
                Date dateNew;
                Date date = (Date)args[0];
                if (date.getTimezone() == null && timezone == null) {
                    dateNew = date;
                } else if (date.getTimezone() == null) {
                    dateNew = new Date(date.getYear(), date.getMonth(), date.getDay(), timezone);
                } else if (timezone == null) {
                    dateNew = new Date(date.getYear(), date.getMonth(), date.getDay(), null);
                } else {
                    int diff;
                    byte old = date.getTimezone().getHours();
                    if (date.getTimezone().isNegative()) {
                        old = (byte)(old * -1);
                    }
                    byte nw = timezone.getHours();
                    if (timezone.isNegative()) {
                        nw = (byte)(nw * -1);
                    }
                    if ((diff = nw - old) == 0) {
                        return date;
                    }
                    dateNew = date.add(new DTD(diff < 0, 0, (byte)Math.abs(diff), 0, 0));
                    dateNew = new Date(dateNew.getYear(), dateNew.getMonth(), dateNew.getDay(), timezone);
                }
                return dateNew;
            }
            case TIME: {
                Time timeNew;
                Time time = (Time)args[0];
                if (time.getTimezone() == null && timezone == null) {
                    timeNew = time;
                } else if (time.getTimezone() == null) {
                    timeNew = new Time(time.getHours(), time.getMinutes(), time.getMicros(), timezone);
                } else if (timezone == null) {
                    timeNew = new Time(time.getHours(), time.getMinutes(), time.getMicros(), null);
                } else {
                    int diff;
                    byte old = time.getTimezone().getHours();
                    if (time.getTimezone().isNegative()) {
                        old = (byte)(old * -1);
                    }
                    byte nw = timezone.getHours();
                    if (timezone.isNegative()) {
                        nw = (byte)(nw * -1);
                    }
                    if ((diff = nw - old) == 0) {
                        return time;
                    }
                    timeNew = time.add(new DTD(diff < 0, 0, (byte)Math.abs(diff), 0, 0));
                    timeNew = new Time(timeNew.getHours(), timeNew.getMinutes(), timeNew.getMicros(), timezone);
                }
                return timeNew;
            }
        }
        return null;
    }

    public static enum Source {
        DATE_TIME,
        DATE,
        TIME;

    }
}

