/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class CodepointsToString
extends AbstractFunction {
    public CodepointsToString(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[0] == null) {
            return Str.EMPTY;
        }
        Iter it = args[0].iterate();
        Item item = it.next();
        if (item == null) {
            return Str.EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        while (item != null) {
            int codePoint = ((IntNumeric)item).intValue();
            if (!(codePoint >= 32 && codePoint <= 55295 || codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF)) {
                throw new QueryException(ErrorCode.ERR_CODE_POINT_NOT_VALID, "Codepoint does not represent a legal XML character: %s.", codePoint);
            }
            sb.append(Character.toChars(codePoint)[0]);
            item = it.next();
        }
        return new Str(sb.toString());
    }
}

