/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AnyURI;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.function.fn.Doc;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.node.NodeCollection;

public class Collection
extends AbstractFunction {
    public Collection(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        String name = args.length > 0 ? ((Str)args[0]).stringValue() : null;
        try {
            if (name == null || name.isEmpty()) {
                NodeCollection<?> collection = ctx.getDefaultCollection();
                if (collection == null) {
                    throw new QueryException(ErrorCode.ERR_COLLECTION_NOT_FOUND, "No default collection defined.");
                }
                return collection;
            }
            AnyURI uri = Doc.resolve(sctx, name);
            return ctx.getNodeStore().lookup(uri.stringValue());
        }
        catch (DocumentException e) {
            throw new QueryException(e, ErrorCode.ERR_COLLECTION_NOT_FOUND, "Collection '%s' not found.", name);
        }
    }
}

