/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.DTD;
import org.brackit.xquery.atomic.Date;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Time;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class DateTime
extends AbstractFunction {
    public DateTime(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        Date date = (Date)args[0];
        Time time = (Time)args[1];
        if (date == null || time == null) {
            return null;
        }
        DTD dateTimeTimezone = date.getTimezone();
        DTD timeTimezone = time.getTimezone();
        if (dateTimeTimezone != null) {
            if (timeTimezone == null || !dateTimeTimezone.eq(timeTimezone)) {
                throw new QueryException(ErrorCode.ERR_DATETIME_FUNCTION_DIFFERENT_TZ, "Arguments of function '%s' have different timezones", this.getName());
            }
        } else {
            dateTimeTimezone = timeTimezone;
        }
        return new org.brackit.xquery.atomic.DateTime(date.getYear(), date.getMonth(), date.getDay(), time.getHours(), date.getMinutes(), date.getMicros(), dateTimeTimezone);
    }
}

