/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class Distinct
extends AbstractFunction {
    public Distinct(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        Str collation;
        if (args.length == 2 && !(collation = (Str)args[1]).stringValue().equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new QueryException(ErrorCode.ERR_UNSUPPORTED_COLLATION, "Unsupported collation: %s", collation);
        }
        final Sequence s = args[0];
        if (s == null || s instanceof Item) {
            return s;
        }
        return new LazySequence(){
            final Sequence inSeq;
            volatile Set<Atomic> set;
            {
                this.inSeq = s;
            }

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    Iterator<Atomic> it;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Item next() throws QueryException {
                        Set<Atomic> distinct = set;
                        if (distinct == null) {
                            distinct = new LinkedHashSet<Atomic>();
                            try (Iter it = inSeq.iterate();){
                                Item runVar;
                                while ((runVar = it.next()) != null) {
                                    distinct.add((Atomic)runVar);
                                }
                            }
                            set = distinct;
                        }
                        if (this.it == null) {
                            this.it = distinct.iterator();
                        }
                        return this.it.hasNext() ? (Item)this.it.next() : null;
                    }

                    @Override
                    public void close() {
                        this.it = null;
                    }
                };
            }
        };
    }
}

