/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AnyURI;
import org.brackit.xquery.atomic.Bool;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.StructuredItem;
import org.brackit.xquery.xdm.StructuredItemCollection;
import org.brackit.xquery.xdm.node.Node;
import org.brackit.xquery.xdm.node.TemporalNodeCollection;

public class Doc
extends AbstractFunction {
    private boolean retrieve;

    public Doc(QNm name, boolean retrieve, Signature signature) {
        super(name, signature, true);
        this.retrieve = retrieve;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[0] == null) {
            return this.retrieve ? null : Bool.FALSE;
        }
        String name = ((Str)args[0]).stringValue();
        int revision = args.length == 2 ? ((Int32)args[1]).intValue() : -1;
        try {
            if (name.isEmpty()) {
                Node<?> document = ctx.getDefaultDocument();
                if (document == null) {
                    if (this.retrieve) {
                        throw new QueryException(ErrorCode.ERR_DOCUMENT_NOT_FOUND, "No default document defined.");
                    }
                    return Bool.FALSE;
                }
                return document;
            }
            AnyURI uri = Doc.resolve(sctx, name);
            StructuredItemCollection collection = ctx.getNodeStore().lookup(uri.stringValue());
            long documents = collection.getDocumentCount();
            if (documents == 0L) {
                if (this.retrieve) {
                    throw new QueryException(ErrorCode.ERR_DOCUMENT_NOT_FOUND, "Empty collection");
                }
                return Bool.FALSE;
            }
            if (documents > 1L) {
                throw new QueryException(ErrorCode.ERR_DOCUMENT_NOT_FOUND, "Collection %s contains more than one document", name);
            }
            StructuredItem document = collection instanceof TemporalNodeCollection ? ((TemporalNodeCollection)collection).getDocument(revision) : collection.getDocument();
            if (document == null) {
                if (this.retrieve) {
                    throw new QueryException(ErrorCode.ERR_DOCUMENT_NOT_FOUND, "Empty collection");
                }
                return Bool.FALSE;
            }
            if (this.retrieve) {
                return document;
            }
            return Bool.FALSE;
        }
        catch (DocumentException e) {
            if (this.retrieve) {
                throw new QueryException(e, ErrorCode.ERR_DOCUMENT_NOT_FOUND, "Document '%s' not found.", name);
            }
            return Bool.FALSE;
        }
    }

    static AnyURI resolve(StaticContext sctx, AnyURI base, AnyURI relative) throws QueryException {
        if (relative.isAbsolute()) {
            return relative;
        }
        if (!(base != null || (base = sctx.getBaseURI()) != null && base.isAbsolute())) {
            return relative;
        }
        try {
            return relative.absolutize(base);
        }
        catch (Exception e) {
            throw new QueryException(e, ErrorCode.ERR_FN_RESOLVE_URI, (Object)"Error resolving URI %s against base URI %s");
        }
    }

    static AnyURI resolve(StaticContext sctx, String relStr) throws QueryException {
        try {
            AnyURI relative = new AnyURI(relStr);
            return Doc.resolve(sctx, null, relative);
        }
        catch (DocumentException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_URI, "Invalid relative URI: %s", relStr);
        }
    }
}

