/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class Encode
extends AbstractFunction {
    private static final List<Character> IRI_ILLEGAL_ASCII = Arrays.asList(Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\"'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('`'));
    private Mode mode;

    public Encode(QNm name, Mode mode, Signature signature) {
        super(name, signature, true);
        this.mode = mode;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[0] == null) {
            return Str.EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        String str = ((Str)args[0]).stringValue();
        int copy = 0;
        switch (this.mode) {
            case ENCODE_FOR_URI: {
                for (int i = 0; i < str.length(); ++i) {
                    int codePoint = str.codePointAt(i);
                    if (codePoint >= 65 && codePoint <= 90 || codePoint >= 97 && codePoint <= 122 || codePoint == 45 || codePoint == 46 || codePoint == 95 || codePoint == 126) continue;
                    if (copy < i) {
                        sb.append(str.substring(copy, i));
                    }
                    int charCount = Character.charCount(codePoint);
                    String seq = String.valueOf(Character.toChars(codePoint));
                    byte[] bytes = null;
                    try {
                        bytes = seq.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    Object code = "";
                    for (byte b : bytes) {
                        code = (String)code + Integer.toHexString(b & 0xFF);
                    }
                    if (((String)(code = ((String)code).toUpperCase())).length() % 2 == 1) {
                        code = "0" + (String)code;
                    }
                    int z = 0;
                    while (z < ((String)code).length()) {
                        sb.append('%');
                        sb.append(((String)code).substring(z, z += 2));
                    }
                    if (charCount == 2) {
                        ++i;
                    }
                    copy = i + 1;
                }
                break;
            }
            case IRI_TO_URI: {
                for (int i = 0; i < str.length(); ++i) {
                    int codePoint = str.codePointAt(i);
                    if (codePoint >= 32 && codePoint <= 126 && !IRI_ILLEGAL_ASCII.contains(Character.valueOf(str.charAt(i)))) continue;
                    if (copy < i) {
                        sb.append(str.substring(copy, i));
                    }
                    int charCount = Character.charCount(codePoint);
                    String seq = String.valueOf(Character.toChars(codePoint));
                    byte[] bytes = null;
                    try {
                        bytes = seq.getBytes(StandardCharsets.UTF_8.toString());
                    }
                    catch (UnsupportedEncodingException code) {
                        // empty catch block
                    }
                    Object code = "";
                    for (byte b : bytes) {
                        code = (String)code + Integer.toHexString(b & 0xFF);
                    }
                    if (((String)(code = ((String)code).toUpperCase())).length() % 2 == 1) {
                        code = "0" + (String)code;
                    }
                    int z = 0;
                    while (z < ((String)code).length()) {
                        sb.append('%');
                        sb.append(((String)code).substring(z, z += 2));
                    }
                    if (charCount == 2) {
                        ++i;
                    }
                    copy = i + 1;
                }
                break;
            }
        }
        if (copy < str.length()) {
            sb.append(str.substring(copy));
        }
        return new Str(sb.toString());
    }

    public static enum Mode {
        ENCODE_FOR_URI,
        IRI_TO_URI,
        HTML_URI;

    }
}

