/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Date;
import org.brackit.xquery.atomic.DateTime;
import org.brackit.xquery.atomic.Dbl;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Time;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class ExtractFromDateTime
extends AbstractFunction {
    private Source source;
    private Comp comp;

    public ExtractFromDateTime(QNm name, Source source, Comp comp, Signature signature) {
        super(name, signature, true);
        this.source = source;
        this.comp = comp;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args.length == 0 || args[0] == null) {
            return null;
        }
        switch (this.source) {
            case DATE_TIME: {
                DateTime dt = (DateTime)args[0];
                switch (this.comp) {
                    case YEAR: {
                        return new Int32(dt.getYear());
                    }
                    case MONTH: {
                        return new Int32(dt.getMonth());
                    }
                    case DAY: {
                        return new Int32(dt.getDay());
                    }
                    case HOURS: {
                        return new Int32(dt.getHours());
                    }
                    case MINUTES: {
                        return new Int32(dt.getMinutes());
                    }
                    case SECONDS: {
                        return new Dbl((double)dt.getMicros() / 1000000.0);
                    }
                    case TIMEZONE: {
                        return dt.getTimezone();
                    }
                }
            }
            case DATE: {
                Date date = (Date)args[0];
                switch (this.comp) {
                    case YEAR: {
                        return new Int32(date.getYear());
                    }
                    case MONTH: {
                        return new Int32(date.getMonth());
                    }
                    case DAY: {
                        return new Int32(date.getDay());
                    }
                    case TIMEZONE: {
                        return date.getTimezone();
                    }
                }
            }
            case TIME: {
                Time time = (Time)args[0];
                switch (this.comp) {
                    case HOURS: {
                        return new Int32(time.getHours());
                    }
                    case MINUTES: {
                        return new Int32(time.getMinutes());
                    }
                    case SECONDS: {
                        return new Dbl((double)time.getMicros() / 1000000.0);
                    }
                    case TIMEZONE: {
                        return time.getTimezone();
                    }
                }
            }
        }
        return null;
    }

    public static enum Source {
        DATE_TIME,
        DATE,
        TIME;

    }

    public static enum Comp {
        YEAR,
        MONTH,
        DAY,
        HOURS,
        MINUTES,
        SECONDS,
        TIMEZONE;

    }
}

