/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractDuration;
import org.brackit.xquery.atomic.Dbl;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.Type;

public class ExtractFromDuration
extends AbstractFunction {
    private Comp comp;

    public ExtractFromDuration(QNm name, Comp comp, Signature signature) {
        super(name, signature, true);
        this.comp = comp;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args.length == 0 || args[0] == null) {
            return null;
        }
        AbstractDuration dur = (AbstractDuration)args[0];
        int value = 0;
        switch (this.comp) {
            case YEARS: {
                if (dur.type().instanceOf(Type.DTD)) {
                    return Int32.ZERO;
                }
                value = dur.getYears();
                break;
            }
            case MONTHS: {
                if (dur.type().instanceOf(Type.DTD)) {
                    return Int32.ZERO;
                }
                value = dur.getMonths();
                break;
            }
            case DAYS: {
                if (dur.type().instanceOf(Type.YMD)) {
                    return Int32.ZERO;
                }
                value = dur.getDays();
                break;
            }
            case HOURS: {
                if (dur.type().instanceOf(Type.YMD)) {
                    return Int32.ZERO;
                }
                value = dur.getHours();
                break;
            }
            case MINUTES: {
                if (dur.type().instanceOf(Type.YMD)) {
                    return Int32.ZERO;
                }
                value = dur.getMinutes();
                break;
            }
            case SECONDS: {
                if (dur.type().instanceOf(Type.YMD)) {
                    return new Dbl(0.0);
                }
                double d = (double)dur.getMicros() / 1000000.0;
                if (dur.isNegative()) {
                    return new Dbl(d * -1.0);
                }
                return new Dbl(d);
            }
        }
        if (dur.isNegative()) {
            return new Int32(value * -1);
        }
        return new Int32(value);
    }

    public static enum Comp {
        YEARS,
        MONTHS,
        DAYS,
        HOURS,
        MINUTES,
        SECONDS;

    }
}

