/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AnyURI;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class ResolveURI
extends AbstractFunction {
    public ResolveURI(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        AnyURI base;
        AnyURI relative;
        if (args[0] == null) {
            return null;
        }
        String relStr = ((Str)args[0]).stringValue();
        String baseStr = args.length == 2 ? ((Str)args[1]).stringValue() : null;
        try {
            relative = new AnyURI(relStr);
        }
        catch (DocumentException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_URI, "Invalid relative URI: %s", relStr);
        }
        try {
            base = baseStr != null ? new AnyURI(baseStr) : null;
        }
        catch (DocumentException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_URI, "Invalid base URI: %s", baseStr);
        }
        return ResolveURI.resolve(sctx, base, relative);
    }

    public static AnyURI resolve(StaticContext sctx, AnyURI base, AnyURI relative) throws QueryException {
        if (relative.isAbsolute()) {
            return relative;
        }
        if (base == null && (base = sctx.getBaseURI()) == null) {
            throw new QueryException(ErrorCode.ERR_UNDEFINED_STATIC_BASE_URI, "Base-URI not defined in static context");
        }
        if (!base.isAbsolute()) {
            throw new QueryException(ErrorCode.ERR_INVALID_URI, "Base URI is not an absolute URI: %s", base);
        }
        try {
            return relative.absolutize(base);
        }
        catch (Exception e) {
            throw new QueryException(e, ErrorCode.ERR_FN_RESOLVE_URI, (Object)"Error resolving URI %s against base URI %s");
        }
    }

    public static AnyURI resolve(StaticContext sctx, String relStr) throws QueryException {
        try {
            AnyURI relative = new AnyURI(relStr);
            return ResolveURI.resolve(sctx, null, relative);
        }
        catch (DocumentException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_URI, "Invalid relative URI: %s", relStr);
        }
    }
}

