/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class StringToCodepoints
extends AbstractFunction {
    public StringToCodepoints(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[0] == null) {
            return null;
        }
        final String subject = ((Str)args[0]).stringValue();
        if (subject.isEmpty()) {
            return null;
        }
        return new LazySequence(){
            final String s;
            {
                this.s = subject;
            }

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    int index = 0;

                    @Override
                    public Item next() throws QueryException {
                        if (this.index == s.length()) {
                            return null;
                        }
                        return new Int32(s.codePointAt(this.index++));
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }
}

