/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class StringTranslate
extends AbstractFunction {
    public StringTranslate(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[0] == null) {
            return Str.EMPTY;
        }
        String str = ((Str)args[0]).stringValue();
        String map = ((Str)args[1]).stringValue();
        String trans = ((Str)args[2]).stringValue();
        StringBuilder sb = new StringBuilder(str.length());
        if (map.isEmpty()) {
            return Str.EMPTY;
        }
        int copy = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int index = map.indexOf(c);
            if (index == -1 || index >= trans.length()) continue;
            if (copy < i) {
                sb.append(str.substring(copy, i));
            }
            sb.append(trans.charAt(index));
            copy = i + 1;
        }
        if (copy < str.length()) {
            sb.append(str.substring(copy));
        }
        return new Str(sb.toString());
    }
}

