/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Numeric;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class Substring
extends AbstractFunction {
    public Substring(QNm name, Signature signature) {
        super(name, signature, true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        double end;
        if (args[0] == null) {
            return Str.EMPTY;
        }
        String string = ((Str)args[0]).stringValue();
        double start = ((Numeric)args[1]).round().doubleValue();
        double d = end = args.length == 3 ? ((Numeric)args[2]).round().doubleValue() : (double)string.length();
        if (Double.isNaN(start) || Double.isNaN(end) || start == Double.NEGATIVE_INFINITY && end == Double.POSITIVE_INFINITY) {
            return Str.EMPTY;
        }
        int startPos = (int)Math.max(start, 1.0) - 1;
        int endPos = (int)Math.min(start + end - 1.0, (double)string.length());
        if (endPos <= startPos || endPos - startPos <= 0) {
            return Str.EMPTY;
        }
        return new Str(string.substring(startPos, endPos));
    }
}

