/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Bool;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class SubstringMatch
extends AbstractFunction {
    private final Mode mode;

    public SubstringMatch(QNm name, Mode mode, Signature signature) {
        super(name, signature, true);
        this.mode = mode;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        String pattern;
        Str collation;
        if (args.length == 3 && !(collation = (Str)args[2]).stringValue().equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new QueryException(ErrorCode.ERR_UNSUPPORTED_COLLATION, "Unsupported collation: %s", collation);
        }
        String str = args[0] != null ? ((Str)args[0]).stringValue() : "";
        String string = pattern = args[1] != null ? ((Str)args[1]).stringValue() : "";
        if (pattern.isEmpty()) {
            return Bool.TRUE;
        }
        if (str.isEmpty()) {
            return Bool.FALSE;
        }
        switch (this.mode) {
            case CONTAINS: {
                return str.contains(pattern) ? Bool.TRUE : Bool.FALSE;
            }
            case STARTS_WITH: {
                return str.startsWith(pattern) ? Bool.TRUE : Bool.FALSE;
            }
            case ENDS_WITH: {
                return str.endsWith(pattern) ? Bool.TRUE : Bool.FALSE;
            }
        }
        throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR);
    }

    public static enum Mode {
        CONTAINS,
        STARTS_WITH,
        ENDS_WITH;

    }
}

