/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.fn;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;

public class SubstringRelative
extends AbstractFunction {
    private boolean before;

    public SubstringRelative(QNm name, boolean before, Signature signature) {
        super(name, signature, true);
        this.before = before;
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        String pattern;
        Str collation;
        if (args.length == 3 && !(collation = (Str)args[2]).stringValue().equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new QueryException(ErrorCode.ERR_UNSUPPORTED_COLLATION, "Unsupported collation: %s", collation);
        }
        if (args[0] == null || args[1] == null) {
            return Str.EMPTY;
        }
        if (((Str)args[1]).stringValue().isEmpty()) {
            if (this.before) {
                return Str.EMPTY;
            }
            return args[0];
        }
        String target = ((Str)args[0]).stringValue();
        int pos = target.indexOf(pattern = ((Str)args[1]).stringValue());
        if (pos == -1) {
            return Str.EMPTY;
        }
        if (this.before) {
            return new Str(target.substring(0, pos));
        }
        return new Str(target.substring(pos + pattern.length()));
    }
}

