/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.io;

import java.io.IOException;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.function.io.IOFun;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.util.annotation.FunctionAnnotation;
import org.brackit.xquery.util.io.IOUtils;
import org.brackit.xquery.util.io.URIHandler;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.SequenceType;

@FunctionAnnotation(description="Loads a resource as plain text.", parameters={"$path"})
public class Read
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/io", "io", "read");

    public Read() {
        this(DEFAULT_NAME);
    }

    public Read(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        try {
            String uri = ((Atomic)args[0]).stringValue();
            String s = IOUtils.getStringFromInputStream(URIHandler.getInputStream(uri));
            return new Str(s);
        }
        catch (IOException e) {
            throw new QueryException(e, IOFun.IO_LOADFILE_INT_ERROR);
        }
    }
}

