/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.function.io.IOFun;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.util.io.URIHandler;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.SequenceType;

public class Readline
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/io", "io", "readline");

    public Readline() {
        this(DEFAULT_NAME);
    }

    public Readline(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.STR, Cardinality.ZeroOrMany), new SequenceType(AtomicType.STR, Cardinality.One)), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        final String uri = ((Atomic)args[0]).stringValue();
        return new LazySequence(){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    BufferedReader in;

                    @Override
                    public Item next() throws QueryException {
                        try {
                            String line;
                            if (this.in == null) {
                                this.in = new BufferedReader(new InputStreamReader(URIHandler.getInputStream(uri)));
                            }
                            return (line = this.in.readLine()) != null ? new Str(line) : null;
                        }
                        catch (Exception e) {
                            throw new QueryException(e, IOFun.IO_LOADFILE_INT_ERROR);
                        }
                    }

                    @Override
                    public void close() {
                        if (this.in != null) {
                            try {
                                this.in.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
        };
    }
}

