/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.function.io.IOFun;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.util.io.URIHandler;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.type.AnyItemType;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.SequenceType;

public class Write
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/io", "io", "write");

    public Write() {
        this(DEFAULT_NAME);
    }

    public Write(QNm name) {
        super(name, new Signature(new SequenceType(AtomicType.INR, Cardinality.One), new SequenceType(AtomicType.STR, Cardinality.One), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany)), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        if (args[1] == null) {
            return Int32.ZERO;
        }
        try {
            IntNumeric count = Int32.ZERO;
            String uri = ((Atomic)args[0]).stringValue();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(URIHandler.getOutputStream(uri, true)));
            try (Iter it = args[1].iterate();){
                Item item;
                while ((item = it.next()) != null) {
                    out.write(item.toString());
                    count = count.inc();
                }
            }
            out.close();
            return count;
        }
        catch (IOException e) {
            throw new QueryException(e, IOFun.IO_WRITEFILE_INT_ERROR);
        }
    }
}

