/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.json;

import java.util.ArrayList;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.array.DArray;
import org.brackit.xquery.atomic.Bool;
import org.brackit.xquery.atomic.Dbl;
import org.brackit.xquery.atomic.Dec;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.Numeric;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.compiler.parser.Tokenizer;
import org.brackit.xquery.function.json.JSONFun;
import org.brackit.xquery.record.ArrayRecord;
import org.brackit.xquery.util.serialize.StringSerializer;
import org.brackit.xquery.xdm.Item;

public class JSONParser
extends Tokenizer {
    public JSONParser(String query) {
        super(query);
    }

    public Item parse() throws QueryException {
        try {
            Item i = this.object();
            Item item = i = i != null ? i : this.array();
            if (i == null) {
                throw new QueryException(JSONFun.ERR_PARSING_ERROR, "No JSON data found");
            }
            this.consumeEOF();
            return i;
        }
        catch (Tokenizer.IllegalCharRefException e) {
            throw new QueryException(e, JSONFun.ERR_PARSING_ERROR, (Object)e.getMessage());
        }
        catch (Exception e) {
            throw new QueryException(e, JSONFun.ERR_PARSING_ERROR, (Object)e.getMessage());
        }
    }

    protected void consumeSkipS(String token) throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipS(token);
        if (la == null) {
            throw (Tokenizer)this.new Tokenizer.TokenizerException("Expected '%s': '%s'", token, this.paraphrase());
        }
        this.consume(la);
    }

    private Item value(boolean required) throws Tokenizer.TokenizerException, QueryException {
        Str i = this.string();
        i = i != null ? i : this.number();
        i = i != null ? i : this.object();
        i = i != null ? i : this.array();
        i = i != null ? i : this.symbol(required);
        return i;
    }

    private Item symbol(boolean required) throws Tokenizer.TokenizerException {
        if (this.attemptSkipS("true")) {
            return Bool.TRUE;
        }
        if (this.attemptSkipS("false")) {
            return Bool.FALSE;
        }
        if (this.attemptSkipS("null")) {
            return null;
        }
        if (required) {
            throw (Tokenizer)this.new Tokenizer.TokenizerException("JSON value expected: %s", this.paraphrase());
        }
        return null;
    }

    private Item array() throws Tokenizer.TokenizerException, QueryException {
        if (!this.attemptSkipS("[")) {
            return null;
        }
        if (this.attemptSkipS("]")) {
            return new ArrayRecord(new QNm[0], new Item[0]);
        }
        ArrayList<Item> values = new ArrayList<Item>();
        do {
            values.add(this.value(true));
        } while (this.attemptSkipS(","));
        this.consumeSkipS("]");
        return new DArray(values);
    }

    private Item object() throws Tokenizer.TokenizerException, QueryException {
        if (!this.attemptSkipS("{")) {
            return null;
        }
        if (this.attemptSkipS("}")) {
            return new ArrayRecord(new QNm[0], new Item[0]);
        }
        int len = 0;
        ArrayList<QNm> fields = new ArrayList<QNm>();
        ArrayList<Item> values = new ArrayList<Item>();
        do {
            Str name;
            if ((name = this.string()) == null) {
                // empty if block
            }
            this.consumeSkipS(":");
            Item value = this.value(true);
            fields.add(new QNm(null, null, name.stringValue()));
            values.add(value);
            ++len;
        } while (this.attemptSkipS(","));
        this.consumeSkipS("}");
        return new ArrayRecord(fields.toArray(new QNm[len]), values.toArray(new Item[len]));
    }

    private Numeric number() throws QueryException, Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laS();
        if (la != null) {
            Tokenizer.Token la2 = this.laInteger(la, true);
            if (la2 != null) {
                this.consume(la);
                this.consume(la2);
                return Int32.parse(la2.string());
            }
            la2 = this.laDecimal(la, true);
            if (la2 != null) {
                this.consume(la);
                this.consume(la2);
                return new Dec(la2.string());
            }
            la2 = this.laDouble(la, true);
            if (la2 != null) {
                this.consume(la);
                this.consume(la2);
                return new Dbl(la2.string());
            }
        } else {
            la = this.laInteger(true);
            if (la != null) {
                this.consume(la);
                return Int32.parse(la.string());
            }
            la = this.laDecimal(true);
            if (la != null) {
                this.consume(la);
                return new Dec(la.string());
            }
            la = this.laDouble(true);
            if (la != null) {
                this.consume(la);
                return new Dbl(la.string());
            }
        }
        return null;
    }

    private Str string() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laS();
        if (la != null) {
            Tokenizer.Token la2 = this.laString(la, true);
            if (la2 != null) {
                this.consume(la);
                this.consume(la2);
                return new Str(la2.string());
            }
        } else {
            la = this.laString(true);
            if (la != null) {
                this.consume(la);
                return new Str(la.string());
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String s = "{\"bindings\": [        {\"ircEvent\": \"PRIVMSG\", \"method\": \"newURI\", \"regex\": \"^http://.*\"},        {\"ircEvent\": \"PRIVMSG\", \"method\": \"deleteURI\", \"regex\": \"^delete.*\"},        {\"ircEvent\": \"PRIVMSG\", \"method\": \"randomURI\", \"regex\": \"^random.*\"}    ]}";
        Item item = new JSONParser(s).parse();
        s = "{\n  \"sirix\": [\n    {\n      \"revisionNumber\": 1,\n      \"revision\": {\n        \"foo\": [\n          \"bar\",\n          null,\n          2.33\n        ],\n        \"bar\": {\n          \"hello\": \"world\",\n          \"helloo\": true\n        },\n        \"baz\": \"hello\",\n        \"tada\": [\n          {\n            \"foo\": \"bar\"\n          },\n          {\n            \"baz\": false\n          },\n          \"boo\",\n          {},\n          []\n        ]\n      }\n    },\n    {\n      \"revisionNumber\": 2,\n      \"revision\": {\n        \"tadaaa\": \"todooo\",\n        \"foo\": [\n          \"bar\",\n          null,\n          2.33\n        ],\n        \"bar\": {\n          \"hello\": \"world\",\n          \"helloo\": true\n        },\n        \"baz\": \"hello\",\n        \"tada\": [\n          {\n            \"foo\": \"bar\"\n          },\n          {\n            \"baz\": false\n          },\n          \"boo\",\n          {},\n          []\n        ]\n      }\n    },\n    {\n      \"revisionNumber\": 3,\n      \"revision\": {\n        \"tadaaa\": \"todooo\",\n        \"foo\": [\n          \"bar\",\n          null,\n          2.33\n        ],\n        \"bar\": {\n          \"hello\": \"world\",\n          \"helloo\": true\n        },\n        \"baz\": \"hello\",\n        \"tada\": [\n          {\n            \"foo\": \"bar\"\n          },\n          {\n            \"baz\": false\n          },\n          \"boo\",\n          {},\n          [\n            {\n              \"foo\": [\n                true,\n                {\n                  \"baz\": \"bar\"\n                }\n              ]\n            }\n          ]\n        ]\n      }\n    }\n  ]\n}";
        item = new JSONParser(s).parse();
        new StringSerializer(System.out).serialize(item);
    }
}

