/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.function.json;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.util.annotation.FunctionAnnotation;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.json.Record;
import org.brackit.xquery.xdm.type.SequenceType;

@FunctionAnnotation(description="Returns an array with the field values of the given record.", parameters={"$record"})
public class Keys
extends AbstractFunction {
    public static final QNm DEFAULT_NAME = new QNm("http://brackit.org/ns/json", "jn", "keys");

    public Keys() {
        this(DEFAULT_NAME);
    }

    public Keys(QNm name) {
        super(name, new Signature(SequenceType.ITEM_SEQUENCE, SequenceType.ITEM_SEQUENCE), true);
    }

    @Override
    public Sequence execute(StaticContext sctx, QueryContext ctx, Sequence[] args) throws QueryException {
        final Sequence sequence = args[0];
        return new LazySequence(){

            @Override
            public Iter iterate() {
                return new BaseIter(){
                    Iter s;
                    final Set<String> stringKeys = new HashSet<String>();
                    final List<Item> keys = new ArrayList<Item>();

                    @Override
                    public Item next() {
                        Item item;
                        if (this.s == null) {
                            this.s = sequence.iterate();
                        }
                        while ((item = this.s.next()) != null) {
                            Item name;
                            if (!(item instanceof Record)) continue;
                            Record record = (Record)item;
                            Iter nameIter = record.names().iterate();
                            while ((name = nameIter.next()) != null) {
                                if (!this.stringKeys.add(name.atomize().stringValue())) continue;
                                this.keys.add(name);
                            }
                        }
                        if (!this.keys.isEmpty()) {
                            return this.keys.remove(0);
                        }
                        return null;
                    }

                    @Override
                    public void close() {
                        if (this.s != null) {
                            this.s.close();
                        }
                    }
                };
            }
        };
    }
}

