/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.module;

import java.util.HashMap;
import java.util.Map;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.xdm.Type;

public class Types {
    protected final Map<QNm, Type> atomicTypes = new HashMap<QNm, Type>();

    public Type resolveSchemaType(QNm name) throws QueryException {
        throw new QueryException(ErrorCode.ERR_UNDEFINED_REFERENCE, "No schema import found for namespace '%s'", name.getNamespaceURI());
    }

    public Type resolveType(QNm name) throws QueryException {
        Type type = this.resolveInternal(name);
        if (type != null) {
            return type;
        }
        throw new QueryException(ErrorCode.ERR_UNDEFINED_REFERENCE, "Unknown type: '%s'", name);
    }

    public Type resolveAtomicType(QNm name) throws QueryException {
        Type type = this.resolveInternal(name);
        if (type != null) {
            return type;
        }
        throw new QueryException(ErrorCode.ERR_UNKNOWN_ATOMIC_SCHEMA_TYPE, "Unknown atomic schema type: '%s'", name);
    }

    private Type resolveInternal(QNm name) {
        if ("http://www.w3.org/2001/XMLSchema".equals(name.getNamespaceURI())) {
            for (Type type : Type.builtInTypes) {
                if (!type.getName().getLocalName().equals(name.getLocalName())) continue;
                return type;
            }
            return null;
        }
        return this.atomicTypes.get(name);
    }
}

